/*
          
T3Series.mqh 
PriceSeries.mqh 
GetDigVelue.mqh
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                       T3.6DigBollinger Bands.mq4 | 
//|                        Copyright  2006,        Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 7
//----  
#property indicator_color1 Gray 
#property indicator_color2 Red
#property indicator_color3 Blue 
#property indicator_color4 Lime
#property indicator_color5 Blue
#property indicator_color6 Red
#property indicator_color7 Gray 
//----   
#property indicator_style1 4
#property indicator_style2 2
#property indicator_style3 4
#property indicator_style4 4
#property indicator_style5 4
#property indicator_style6 2
#property indicator_style7 4
//----    --------------------------------------------------------------------------------------------------+
extern int        Bands_Period = 100; //    J2Bollinger Bands
extern double Bands_Deviations = 2.0; //  
extern int           MA_method = 0;   //  
extern int           MA_Smooth = 20;  //    Moving Avereges
extern int        Bands_Smooth = 20;  //    Bollinger Bands
extern int    Smooth_Curvature = 100; //  ,    -100 ... +100,     ; 
extern int                Step = 6;   // ,         
extern int         Bands_Shift = 0;   // c     
extern int Input_Price_Customs = 0;   // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi High, 12-Heiken Ashi Low, 13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double UpperBuffer3  [];
double UpperBuffer2  [];
double UpperBuffer1  [];
double T3MovingBuffer[];
double LowerBuffer1  [];
double LowerBuffer2  [];
double LowerBuffer3  [];
double Series_buffer [];
//----      
double Norma;
//+------------------------------------------------------------------+ 
//----+   T3Series 
//----+   T3SeriesResize 
//----+   T3SeriesAlert 
//----+   T3_ErrDescr  
#include <T3Series.mqh> 
//+------------------------------------------------------------------+ 
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+ 
//----+   GetDigVelue
#include <GetDigVelue.mqh>
//+------------------------------------------------------------------+  
//| T3.6Bollinger Bands initialization function                      | 
//+------------------------------------------------------------------+  
int init()
  {
//----    
   SetIndexStyle(0,DRAW_LINE); 
   SetIndexStyle(1,DRAW_LINE);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexStyle(3,DRAW_LINE); 
   SetIndexStyle(4,DRAW_LINE);
   SetIndexStyle(5,DRAW_LINE); 
   SetIndexStyle(6,DRAW_LINE);
//---- 4       
   IndicatorBuffers(8);
   SetIndexBuffer(0,UpperBuffer3 );
   SetIndexBuffer(1,UpperBuffer2 );
   SetIndexBuffer(2,UpperBuffer1 );
   SetIndexBuffer(3,T3MovingBuffer);
   SetIndexBuffer(4,LowerBuffer1 );
   SetIndexBuffer(5,LowerBuffer2 );
   SetIndexBuffer(6,LowerBuffer3 );
   SetIndexBuffer(7,Series_buffer);
//----   ,      
   SetIndexEmptyValue(0,0);
   SetIndexEmptyValue(1,0);
   SetIndexEmptyValue(2,0);
   SetIndexEmptyValue(3,0);
   SetIndexEmptyValue(4,0);
   SetIndexEmptyValue(5,0);
   SetIndexEmptyValue(6,0);
//----   ,        
   int drawbegin=100+Bands_Shift;
   SetIndexDrawBegin(0,drawbegin);
   SetIndexDrawBegin(1,drawbegin);
   SetIndexDrawBegin(2,drawbegin);
   SetIndexDrawBegin(3,drawbegin);
   SetIndexDrawBegin(4,drawbegin);
   SetIndexDrawBegin(5,drawbegin);
   SetIndexDrawBegin(6,drawbegin);
//----      
   SetIndexShift (0, Bands_Shift); 
   SetIndexShift (1, Bands_Shift); 
   SetIndexShift (2, Bands_Shift); 
   SetIndexShift (3, Bands_Shift); 
   SetIndexShift (4, Bands_Shift); 
   SetIndexShift (5, Bands_Shift); 
   SetIndexShift (6, Bands_Shift); 
//----        
   IndicatorShortName ("T3.4Bollinger Bands( Period="+Bands_Period+", Deviations="+Bands_Deviations+")"); 
   SetIndexLabel (0, "Upper3 Bands");
   SetIndexLabel (1, "Upper2 Bands");
   SetIndexLabel (2, "Upper1 Bands"); 
   SetIndexLabel (4, "Lower1 Bands"); 
   SetIndexLabel (5, "Lower2 Bands"); 
   SetIndexLabel (6, "Lower3 Bands"); 
   string Moving;
   switch(MA_method)
           {
            case  0: Moving= "T3SMA";break;
            case  1: Moving= "T3EMA";break;
            case  2: Moving="T3SSMA";break;
            case  3: Moving="T3LWMA";break;
            default: Moving="T3SMA";
           }
   SetIndexLabel (3, "Moving Avereges "+Moving+" ("+Bands_Period+")");
//----     
   IndicatorDigits(Digits);
//----+      T3Series, nT3.number=7(    T3Series)
   if (Bands_Smooth<=1){if (T3SeriesResize(1)!=1)return(-1);}else if (T3SeriesResize(7)!=7)return(-1);
//----       
   T3SeriesAlert(0,"MA_Smooth",MA_Smooth);
   T3SeriesAlert(0,"Bands_Period",Bands_Period);
   PriceSeriesAlert(Input_Price_Customs);
   if((MA_method<0)||(MA_method>3))
          Alert(" MA_method    0  3" + "    " 
                                                                +MA_method+ "   0");
//----     Bands_Period
   if(Bands_Period<1)Bands_Period=1; 
//----  
   Norma=Step*Point;
//----  
   return(0);
  }
//+------------------------------------------------------------------+  
//| T3.6Bollinger Bands iteration function                           | 
//+------------------------------------------------------------------+  
int start()
  {
//----       
if(Bars-1<=Bands_Period) return(0);
//----       
double deviation1,deviation2,deviation3,Temp_Series,sum,midline,priceswing,Resalt;
//----+        
int reset,MaxBar,MaxBarBB,MaxBarBB1,bar,kk,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
//---- (    counted_bars  T3Series   !!!)
if (counted_bars>0) counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1;MaxBar=Bars-1-Bands_Period;MaxBarBB=MaxBar-30-Bands_Period;MaxBarBB1=MaxBarBB-1;
//----+              
for(bar=limit;bar>=0;bar--)Series_buffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----       Bollinger Bands 
//----            
if (limit>MaxBar)
     {
      for(bar=limit;bar>=MaxBar;bar--)T3MovingBuffer[bar]=0;
      limit=MaxBar;
     }
//----+   Moving Avereges
for(bar=limit;bar>=0;bar--)
  {
   //----+    Moving Avereges
   Temp_Series=iMAOnArray(Series_buffer,0,Bands_Period,0,MA_method, bar);
   //----+   Moving Avereges
   //----+    T3Series   0.  nT3.Curvature  nT3.Length      (nT3.din=0)
   midline=T3Series(0,0,MaxBar,limit,Smooth_Curvature,MA_Smooth,Temp_Series,bar,reset);
   //----+       
   if(reset!=0)return(-1);     
   T3MovingBuffer[bar]=GetDigVelue(Norma,midline);    
   //---- ר Bollinger Bands 
   //----        
   if (bar>MaxBarBB)
      {
       UpperBuffer2[bar]=0;
       UpperBuffer1[bar]=0;
       LowerBuffer1[bar]=0;
       LowerBuffer2[bar]=0;
       continue;
      }
   //---- 
   sum=0.0;
   kk=bar+Bands_Period-1;
   while(kk>=bar)
      {
       priceswing=PriceSeries(Input_Price_Customs,kk)-midline;
       sum+=priceswing*priceswing;
       kk--;
      }
   deviation2=Bands_Deviations*MathSqrt(sum/Bands_Period);     
   deviation1=0.5*deviation2;
   deviation3=1.5*deviation2;
   if (Bands_Smooth>1)
      {
         //----+   T3  Bollinger Bands      
         //----+ ----------------------------------------------------------------------------------------+            
         //----+      T3Series   1, 2, 3, 4, 5, 6. 
         //----+  nT3.Length  t    (nT3.din=0)
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(1,0,MaxBarBB1,limit,Smooth_Curvature,Bands_Smooth ,midline+deviation3,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer3[bar]=GetDigVelue(Norma,Resalt);  
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(2,0,MaxBarBB1,limit,Smooth_Curvature,Bands_Smooth ,midline+deviation2,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer2[bar]=GetDigVelue(Norma,Resalt); 
         //----+ ----------------------------------------------------------------------------------------+       
         Resalt=T3Series(3,0,MaxBarBB1,limit,Smooth_Curvature,Bands_Smooth ,midline+deviation1,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         UpperBuffer1[bar]=GetDigVelue(Norma,Resalt); 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(4,0,MaxBarBB1,limit,Smooth_Curvature,Bands_Smooth ,midline-deviation1,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer1[bar]=GetDigVelue(Norma,Resalt); 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(5,0,MaxBarBB1,limit,Smooth_Curvature,Bands_Smooth ,midline-deviation2,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer2[bar]=GetDigVelue(Norma,Resalt); 
         //----+ ----------------------------------------------------------------------------------------+ 
         Resalt=T3Series(6,0,MaxBarBB1,limit,Smooth_Curvature,Bands_Smooth ,midline-deviation3,bar,reset);
         //----+       
         if(reset!=0)return(-1); 
         LowerBuffer3[bar]=GetDigVelue(Norma,Resalt);       
         //----+ ----------------------------------------------------------------------------------------+ 
      }
   else 
      {
         //----+  Bollinger Bands  T3  
         UpperBuffer3[bar]=GetDigVelue(Norma,midline+deviation3);  
         UpperBuffer2[bar]=GetDigVelue(Norma,midline+deviation2); 
         UpperBuffer1[bar]=GetDigVelue(Norma,midline+deviation1); 
         LowerBuffer1[bar]=GetDigVelue(Norma,midline-deviation1); 
         LowerBuffer2[bar]=GetDigVelue(Norma,midline-deviation2); 
         LowerBuffer3[bar]=GetDigVelue(Norma,midline-deviation3);  
      }
      
   }
//----    
   return(0);
  }
//+-------------------------------------------------------------------------------------+


